#include <stdint.h>
#include <stdbool.h>
#include "inc/tm4c123gh6pm.h"
#define ADC_channels 3//1)reference 2)current 3)speed
float temp_result=0;
int ADC_buff[ADC_channels];
float Nu=0.284;
int result;
float duty1=0;
float duty2=0;
float ref;
float c_meas;
float W_meas=0;

void delayMs(int n);
void PWM_init_PF3(int freq_khz,float initial_duty);
void PWM_init_PE4(int freq,float initial_duty);
void clock_configuration();
void PWM0GEN2_ISR();
void ADC_SS2_ISR(void);
void EnableInterrupts(void);
void timer0A_init(void);
void ADC_config();

int start_motor_flag=0;
int calculate_flag=0;
double prev_ref;
double set_point = 1.9; //voltage ip at mid pt
double total_error = 0;
double present_error;
double correction;
#define DUTY_MIN 0.04
#define DUTY_MAX 0.96
#define PWM_LOAD 4000
#define TIMER_LOAD 1000 //2ms
#define DUTY_SCALER 1.3 // 1.3, 54.23 sec, 1.55, 37.66 sec, 1.7, 32.23 sec
#define LEFT_WHEEL_OFFSET 0.00125

int main(void)
   {

    clock_configuration();
    PWM_init_PF3(2,0.025);
    PWM_init_PE4(2,0.018);
    ADC_config();
    timer0A_init();
    NVIC_EN0_R = 0x00010000; //enable interrupt for ADC0 SS2
    EnableInterrupts();
    GPIO_PORTD_DIR_R |= 0x01;
    GPIO_PORTD_DEN_R |= 0x01;

    // change the duty cycles of individual wheels according to correction value
    while(1)
    {
        if(calculate_flag==1)
        {
            calculate_flag=0;
            duty1=(float)(DUTY_SCALER)*(0.1+correction);
            duty2=(float)(DUTY_SCALER)*(0.10-(correction + LEFT_WHEEL_OFFSET));
            //Left Wheel offset can be removed after placing the extra wheel in the middle to balance weights => currently it's biased
            //Clamp duty cycles to min and max valid values
            if(duty1<0)
            {
                duty1 = DUTY_MIN;
            }
            if(duty1>1)
            {
                duty1 = DUTY_MAX;
            }
            if(duty2<0)
            {
                duty2 = DUTY_MIN;
            }
            if(duty2>1)
            {
                duty2 = DUTY_MAX;
            }
            PWM1_3_CMPA_R = (int)(PWM_LOAD * duty1); //duty1, duty2 are between 0 and 1 => CMPA values are between 0 and PWM_LOAD
            PWM0_2_CMPA_R = (int)(PWM_LOAD * duty2);

        }

    }
}


/* delay n milliseconds (16 MHz CPU clock) */
void delayMs(int n)
{
    int i, j;

    for(i = 0 ; i < n; i++)
        for(j = 0; j < 3180; j++)
            {}  /* do nothing for 1 ms */
}

void timer0A_init(void)
{
    SYSCTL_RCGCTIMER_R |= 1;
    TIMER0_CTL_R = 0;  // DISABLE TIMER
    TIMER0_CFG_R = 0x04;  //16 BIT MODE
    TIMER0_TAMR_R = 0x02;  // DOWN COUNT AND PERIODIC
    TIMER0_TAILR_R = TIMER_LOAD - 1;  //LOAD VALUE - MACRO
    TIMER0_TAPR_R = 16 - 1;  //PRESCALER VALUE
    TIMER0_ICR_R = 0x1;  // CLEARING TIMEOUT INTERRUPTS
    TIMER0_IMR_R = 0X00000001;  //TIMEOUT ENABLE
    NVIC_PRI4_R = (NVIC_PRI4_R & 0x8FFFFFFF) | 0X30000000;
    NVIC_EN0_R = 0x00080000; // ENABLING PEERIODIC INTERRUPTS FROM TIMER0
    TIMER0_CTL_R |= 0x01; //ENABLE TIMER AND START COUNTING
    //EnableInterrupts();
}

void PWM_init_PF3(int freq,float initial_duty)
{
    /* Enable port PF3 for PWM1 M1PWM7 */
    GPIO_PORTF_AFSEL_R = 8;      /* PF3 uses alternate function */
    GPIO_PORTF_PCTL_R &= ~0x0000F000; /* make PF3 PWM output pin */
    GPIO_PORTF_PCTL_R |= 0x00005000;
    GPIO_PORTF_DEN_R |= 8;       /* pin digital */
    PWM1_3_CTL_R = 0x02;            /* stop counter */
    PWM1_3_GENB_R = 0x000000E0;  /* M1PWM7 output set when reload, */
    PWM1_3_LOAD_R = PWM_LOAD;       /* set load value for 10kHz (16MHz/1600) */
    PWM1_3_CMPA_R = (int)(PWM_LOAD*initial_duty);       /* set duty cycle to 0.5 */
    PWM1_3_CTL_R = 0x03;            /* start timer */
    PWM1_ENABLE_R = 0x80;        /* start PWM1 ch7 */
}

void PWM_init_PE4(int freq,float initial_duty)
{
    /* Enable port PE4 for PWM0 M0PWM4 */
    GPIO_PORTE_AFSEL_R = 0x10;      /* PE4 uses alternate function */
    GPIO_PORTE_PCTL_R &= ~0x000F0000; /* make PE4 PWM output pin */
    GPIO_PORTE_PCTL_R |= 0x00040000;
    GPIO_PORTE_DEN_R |= 0x10;       /* pin digital */
    PWM0_2_CTL_R = 0x02;            /* stop counter */
    PWM0_2_GENA_R = 0x000000E0;  /* M0PWM4 output set when reload, */
    PWM0_2_LOAD_R = PWM_LOAD; //4000===500
    PWM0_2_CMPA_R = (int)(PWM_LOAD*initial_duty);
    PWM0_2_CTL_R = 0x03;            /* start timer */
    PWM0_ENABLE_R = 0x10;        /* start PWM0 ch4 */
    PWM0_INTEN_R |= 0x04;
    PWM0_2_INTEN_R |=0x00000808;
    NVIC_EN0_R |= 0x00001000;        /*  Enable interrupt for PWM2 in pwm module 0  in NVIC */
}


void clock_configuration()
{
    /* Enable Peripheral Clocks */
    SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */
    SYSCTL_RCGCPWM_R |= 1;       /* enable clock to PWM0 */
    for(int i=0;i<100;i++);
    SYSCTL_RCGCGPIO_R |= 0x38;   /* enable clock to PORTF and PORTD and PORTE*/
    for(int i=0;i<100;i++);
    SYSCTL_RCC_R &= ~0x001C0000; /* pre-divide for PWM0 clock - by 64 */
    SYSCTL_RCC_R |= 0x00100000;
    for(int i=0;i<100;i++);
    SYSCTL_RCGCADC_R |= 1;       /* enable clock to ADC0 */
}

void PWM0GEN2_ISR()
{
    PWM0_2_ISC_R|=0x00000008;
}

void EnableInterrupts(void)
{
    __asm  ("    CPSIE  I\n");
}

void ADC_config()
{
    //here we will be using PE3(AIN0),PE2(AIN1),PE1(AIN2) pins for the analog inputs
    /* initialize ADC0 */
    GPIO_PORTE_AFSEL_R |= 0x07;   /* enable alternate function */
    GPIO_PORTE_DEN_R &= ~0x07;    /* disable digital function */
    GPIO_PORTE_AMSEL_R |= 0x07;   /* enable analog function */
    ADC0_ACTSS_R &= ~4;          /* disable SS2 during configuration */
    ADC0_EMUX_R &= ~0x0F00;
    ADC0_EMUX_R |= 0x0800;       /* PWM0 gen2 trigger conversion seq  */
    ADC0_TSSEL_R&=~0x00300000;
    ADC0_SSMUX2_R = 0X3210;           /* get input from channel 0,1,2. LEAVE 3 */
    ADC0_SSCTL2_R |= 0x0600;       /* take one value, set flag at 1st sample */
    ADC0_ACTSS_R |= 4;           /* enable ADC0 sequencer 2 */
    ADC0_IM_R|=0x04;//Sends the raw interrupt to the interrupt manager upon conversion
}


void ADC_SS2_ISR(void)
{
    int i=0;
    ADC0_ISC_R |= 0x04;
    while(i<ADC_channels)
    {
        ADC_buff[i] = ADC0_SSFIFO2_R;  //(i=0||PE3)ref (i=1||PE2)omega (i=2||PE1)current
        i++;
    }
    ref=(float)(ADC_buff[0]*3.3)/(float)4096;
    c_meas=(float)(ADC_buff[2]*1.7*3.3)/(float)4096;
    W_meas=(float)(ADC_buff[1]*3.3)/(float)4096;
    calculate_flag=1;
}



void timer0_handler(void)
{
    //pid control for duty cycles
    double Kp = 0.1, Ki = 0.0002, Kd = 0;//0.48 //0.0
    double present_error,dt = 0.002;   //dt=2 ms which timer overflow interrupt
    TIMER0_ICR_R = 0x1;  //clear timeout

    double Deviation = (prev_ref - set_point) - (ref - set_point);
    prev_ref = ref;
    present_error = set_point - ref;

    //PID algorithm
    correction = Kp * (present_error) + Ki * total_error + Kd * Deviation/dt;
    total_error = total_error + present_error*dt;

}

